/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.WSRMCallbackData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.sandesha.util.PolicyLoader;

public class WSRMSequenceInfo {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    protected static final String m_className = "WSRMSequenceInfo";
    private static final int RM_STATUS_REQUEST_CREATE_SEQ_REQ = 1;
    private static final int RM_STATUS_REQUEST_CREATE_SEQ_RESP = 2;
    private static final int RM_STATUS_REQUEST_SERVICE_REQ = 3;
    private static final int RM_STATUS_REQUEST_SERVICE_REQ_ACK = 4;
    private static final int RM_STATUS_REQUEST_SEQ_TERMINATE = 5;
    private static final int RM_STATUS_RESP_CREATE_SEQ_REQ = 6;
    private static final int RM_STATUS_RESP_CREATE_SEQ_RESP = 7;
    private static final int RM_STATUS_RESP_SERVICE_RESP = 8;
    private static final int RM_STATUS_RESP_SERVICE_RESP_ACK = 9;
    private static final int RM_STATUS_RESP_SEQ_TERMINATE = 10;
    public static final int RM_STATUS_INVOKE_CREATE_SEQ_REQ = 1;
    public static final int RM_STATUS_INVOKE_CREATE_SEQ_RESP = 2;
    public static final int RM_STATUS_INVOKE_SERVICE_REQ = 3;
    public static final int RM_STATUS_INVOKE_SERVICE_REQ_ACK = 4;
    public static final int RM_STATUS_INVOKE_SEQ_TERMINATE = 5;
    public static final int RM_STATUS_INVOKE_RESP_CREATE_SEQ_REQ = 6;
    public static final int RM_STATUS_INVOKE_RESP_CREATE_SEQ_RESP = 7;
    public static final int RM_STATUS_INVOKE_RESP_SERVICE_RESP = 8;
    public static final int RM_STATUS_INVOKE_RESP_SERVICE_RESP_ACK = 9;
    public static final int RM_STATUS_INVOKE_RESP_SEQ_TERMINATE = 10;
    public static final int RM_STATUS_RECEIVE_CREATE_SEQ_REQ = 21;
    public static final int RM_STATUS_RECEIVE_CREATE_SEQ_RESP = 22;
    public static final int RM_STATUS_RECEIVE_SERVICE_REQ = 23;
    public static final int RM_STATUS_RECEIVE_SERVICE_REQ_ACK = 24;
    public static final int RM_STATUS_RECEIVE_SEQ_TERMINATE = 25;
    public static final int RM_STATUS_RECEIVE_REPLY_CREATE_SEQ_REQ = 26;
    public static final int RM_STATUS_RECEIVE_REPLY_CREATE_SEQ_RESP = 27;
    public static final int RM_STATUS_RECEIVE_REPLY_SERVICE_RESP = 28;
    public static final int RM_STATUS_RECEIVE_REPLY_SERVICE_RESP_ACK = 29;
    public static final int RM_STATUS_RECEIVE_REPLY_SEQ_TERMINATE = 30;
    public static final int RM_STATUS_RESPONSE_CREATE_SEQ_REQ = 41;
    public static final int RM_STATUS_RESPONSE_CREATE_SEQ_RESP = 42;
    public static final int RM_STATUS_RESPONSE_SERVICE_RESP = 43;
    public static final int RM_STATUS_RESPONSE_SERVICE_RESP_ACK = 44;
    public static final int RM_STATUS_RESPONSE_SEQ_TERMINATE = 45;
    private static Hashtable sequencesByMsgId = new Hashtable();
    private static Hashtable sequencesBySeqId = new Hashtable();
    private static Hashtable sequencesByWobnum = new Hashtable();
    private static Vector sequenceInfos = new Vector();
    private static Vector waitForResponseWOBs = new Vector();
    private static int totalMessageTypes = 6;
    private static long minCleanupInterval = 60000L;
    private static long lastCleanupTime = System.currentTimeMillis();
    private boolean m_bInvoke = false;
    private int m_invokeType = -1;
    private ArrayList m_seqIds = new ArrayList();
    private ArrayList m_msgIds = new ArrayList();
    private boolean[] m_incomingMsgRecd = new boolean[totalMessageTypes];
    private boolean[] m_outgoingMsgRecd = new boolean[totalMessageTypes];
    private String m_relatesToMsgId = null;
    private String m_wobNum = null;
    private boolean m_bWaitForResponse = false;
    private boolean m_serviceMsgReceived = false;
    private boolean m_servicePerformed = false;
    private boolean m_bSeqTerminated = false;
    private boolean m_bAck = false;
    private long m_createTime = 0L;
    private long m_obsoleteTime = 0L;
    private static String EOL = "\n";
    public static final VWString s_invoke_msg = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_msg", "WSReliable Messaging Invoke - {0}");
    public static final VWString s_reply_msg = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_reply_msg", "WSReliable Messaging Reply - {0}");
    public static final VWString s_receive_msg = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_receive_msg", "WSReliable Messaging Receive - {0}");
    public static final VWString s_response_msg = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_response_msg", "WSReliable Messaging Response - {0}");
    public static final String s_invoke_create_sequence = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_create_sequence", "Message sent to web service requesting a reliable messaging communication sequence for an Invoke service request.").toString();
    public static final String s_invoke_create_sequence_resp = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_create_sequence_resp", "Communication sequence is established for an Invoke service request. The service request message has not yet been sent to the web service.").toString();
    public static final String s_invoke_service_request = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_service_request", "Invoke service request was sent to the web service. Waiting for acknowledgement from the web service.").toString();
    public static final String s_invoke_service_request_ack = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_service_request_ack", "Message received from the web service acknowledging receipt of the Invoke service request.").toString();
    public static final String s_invoke_terminated = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_terminated", "Terminated service request communication sequence.").toString();
    public static final String s_invoke_terminated_wiating_for_reply = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_terminated_wiating_for_reply", "Terminated service request communication sequence. Expecting Reply message from web service.").toString();
    public static final String s_invoke_resp_create_sequence = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_resp_create_sequence", "Request received from a web service to establish a reliable messaging communication sequence for a Reply message.").toString();
    public static final String s_invoke_resp_create_sequence_resp = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_resp_create_sequence_resp", "Communication sequence is established for a Reply message. Waiting for the Reply message.").toString();
    public static final String s_invoke_resp_service_response = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_resp_service_response", "Reply message received from the web service.").toString();
    public static final String s_invoke_resp_service_response_ack = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_resp_service_response_ack", "Message sent to web service acknowledging receipt of Reply message.").toString();
    public static final String s_invoke_resp_terminated = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_invoke_resp_terminated", "Terminated reply communication sequecne.").toString();
    public static final String s_receive_create_sequence = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_receive_create_sequence", "Received sequence communication request. Establishing sequence for Receive.").toString();
    public static final String s_receive_create_sequence_resp = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_receive_create_sequence_resp", "Receive communication sequence established. Waiting for service request message.").toString();
    public static final String s_receive_service_request = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_receive_service_request", "Service request message received.").toString();
    public static final String s_receive_service_request_ack = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_receive_service_request_ack", "Message sent acknowledging receipt of service request.").toString();
    public static final String s_receive_terminated = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_receive_terminated", "Service request communication sequence terminated").toString();
    public static final String s_response_service_response = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_response_service_response", "Service response message received.").toString();
    public static final String s_response_service_response_ack = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_response_service_response_ack", "Message sent acknowledging receipt of service response.").toString();
    public static final String s_response_terminated = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_response_terminated", "Service response communication sequence terminated").toString();
    public static final String s_reply_create_sequence = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_reply_create_sequence", "Establishing a Reply communication sequence.").toString();
    public static final String s_reply_create_sequence_resp = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_reply_create_sequence_resp", "Reply communication sequence established.").toString();
    public static final String s_reply_service_request = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_reply_service_request", "Reply message sent.").toString();
    public static final String s_reply_service_request_ack = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_reply_service_request_ack", "Message acknowledging receipt of reply message.").toString();
    public static final String s_reply_terminate = new VWString("filenet.ws.listener.axis.rm.WSRMSequenceInfo.s_reply_terminate", "Terminating reply sequence.").toString();

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 21:21:44  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WSRMSequenceInfo(WSRMCallbackData cbData) {
        String m_method = "ctor";
        logger.entering(m_className, m_method);
        this.m_createTime = System.currentTimeMillis();
        try {
            for (int i = 0; i < totalMessageTypes; ++i) {
                this.m_incomingMsgRecd[i] = false;
                this.m_outgoingMsgRecd[i] = false;
            }
            this.setInfo(cbData);
            sequenceInfos.add(this);
            this.m_bInvoke = cbData.getMessageType() != 1 || !cbData.getIncoming();
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized WSRMSequenceInfo getSequenceInfo(WSRMCallbackData cbData) {
        String m_method = "getSequenceInfo";
        logger.entering(m_className, m_method);
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "MsgType = " + cbData.getMessageType());
            logger.finest(m_className, m_method, "SeqId = " + cbData.getSequenceId());
            logger.finest(m_className, m_method, "MsgId = " + cbData.getMessageId());
            logger.finest(m_className, m_method, "RelatesToMsgId = " + cbData.getRelatesToMsgId());
        }
        try {
            String msgId;
            WSRMSequenceInfo seqInfo = null;
            WSRMSequenceInfo relatesSeqInfo = null;
            if (cbData.getMessageType() == 1) {
                if (cbData.getSequenceId() != null) {
                    seqInfo = WSRMSequenceInfo.getSequenceInfoBySeqId(cbData.getSequenceId());
                } else if (cbData.getMessageId() != null) {
                    seqInfo = WSRMSequenceInfo.getSequenceInfoByMsgId(cbData.getMessageId());
                }
            } else if (cbData.getMessageType() == 2) {
                msgId = cbData.getRelatesToMsgId();
                if (msgId == null) {
                    msgId = cbData.getMessageId();
                }
                if (msgId != null) {
                    seqInfo = WSRMSequenceInfo.getSequenceInfoByMsgId(msgId);
                }
            } else if (cbData.getMessageType() == 4 && (msgId = cbData.getRelatesToMsgId()) != null && (relatesSeqInfo = WSRMSequenceInfo.getSequenceInfoByMsgId(msgId)) != null) {
                relatesSeqInfo.m_relatesToMsgId = cbData.getMessageId();
            }
            if (seqInfo == null && cbData.getSequenceId() != null) {
                seqInfo = WSRMSequenceInfo.getSequenceInfoBySeqId(cbData.getSequenceId());
            }
            if (seqInfo == null) {
                WSRMSequenceInfo.cleanup();
                seqInfo = new WSRMSequenceInfo(cbData);
                if (logger.isFinest()) {
                    logger.finest(m_className, "getSequenceInfo", "New SeqInfo object. SeqId = " + seqInfo.getSeqIds().get(0));
                }
            } else {
                seqInfo.setInfo(cbData);
            }
            WSRMSequenceInfo wSRMSequenceInfo = seqInfo;
            return wSRMSequenceInfo;
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
            WSRMSequenceInfo wSRMSequenceInfo = null;
            return wSRMSequenceInfo;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized WSRMSequenceInfo getSequenceInfoByMsgId(String msgId) {
        String m_method = "getSequenceInfoByMsgId";
        logger.entering(m_className, m_method + "(" + msgId + ")");
        try {
            WSRMSequenceInfo seqInfo = null;
            if (msgId != null) {
                seqInfo = (WSRMSequenceInfo)sequencesByMsgId.get(msgId);
            }
            if (seqInfo == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "SeqInfo = null");
                }
            } else if (logger.isFinest()) {
                logger.finest(m_className, m_method, "SeqInfo found");
            }
            WSRMSequenceInfo wSRMSequenceInfo = seqInfo;
            return wSRMSequenceInfo;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized WSRMSequenceInfo getSequenceInfoBySeqId(String seqId) {
        String m_method = "getSequenceInfoBySeqId";
        logger.entering(m_className, m_method + "(" + seqId + ")");
        try {
            WSRMSequenceInfo seqInfo = null;
            Object obj = null;
            if (seqId != null && (obj = sequencesBySeqId.get(seqId)) != null && obj instanceof WSRMSequenceInfo) {
                seqInfo = obj;
            }
            if (seqInfo == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "SeqInfo = null");
                }
            } else if (logger.isFinest()) {
                logger.finest(m_className, m_method, "SeqInfo found");
            }
            WSRMSequenceInfo wSRMSequenceInfo = seqInfo;
            return wSRMSequenceInfo;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized WSRMSequenceInfo getSequenceInfoByWobnum(String wobnum) {
        String m_method = "getSequenceInfoByWobnum";
        logger.entering(m_className, m_method + "(" + wobnum + ")");
        try {
            WSRMSequenceInfo seqInfo = null;
            Object obj = null;
            if (wobnum != null && (obj = sequencesByWobnum.get(wobnum)) != null && obj instanceof WSRMSequenceInfo) {
                seqInfo = obj;
            }
            if (seqInfo == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "SeqInfo = null");
                }
            } else if (logger.isFinest()) {
                logger.finest(m_className, m_method, "SeqInfo found");
            }
            WSRMSequenceInfo wSRMSequenceInfo = seqInfo;
            return wSRMSequenceInfo;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void cleanup() {
        String m_method = "cleanup";
        try {
            long currentTime = System.currentTimeMillis();
            logger.entering(m_className, m_method);
            if (currentTime - lastCleanupTime > minCleanupInterval) {
                long inactivityTimeOut = PolicyLoader.getInstance().getInactivityTimeout();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Doing cleanup");
                }
                lastCleanupTime = currentTime;
                WSRMSequenceInfo seqInfo = null;
                Vector<WSRMSequenceInfo> seqToRemove = new Vector<WSRMSequenceInfo>();
                Object obj = null;
                for (int i = 0; i < sequenceInfos.size(); ++i) {
                    obj = sequenceInfos.get(i);
                    if (obj == null || !(obj instanceof WSRMSequenceInfo) || (seqInfo = (WSRMSequenceInfo)obj) == null || !seqInfo.isObsolete() || currentTime - seqInfo.m_obsoleteTime <= inactivityTimeOut) continue;
                    seqToRemove.add(seqInfo);
                }
                String seqId = null;
                String msgId = null;
                for (int i = 0; i < seqToRemove.size(); ++i) {
                    int j;
                    obj = seqToRemove.get(i);
                    if (obj == null || !(obj instanceof WSRMSequenceInfo)) continue;
                    seqInfo = obj;
                    ArrayList list = seqInfo.getMsgIds();
                    for (j = 0; j < list.size(); ++j) {
                        msgId = (String)list.get(j);
                        if (sequencesByMsgId.get(msgId) == null) continue;
                        sequencesByMsgId.remove(msgId);
                    }
                    list = seqInfo.getSeqIds();
                    for (j = list.size() - 1; j >= 0; --j) {
                        seqId = (String)list.get(j);
                        if (sequencesBySeqId.get(seqId) == null) continue;
                        sequencesBySeqId.remove(seqId);
                    }
                    if (seqInfo.getwobNum() != null && sequencesByWobnum.containsKey(seqInfo.getwobNum())) {
                        sequencesByWobnum.remove(seqInfo.getwobNum());
                    }
                    if (sequenceInfos.contains(seqInfo)) {
                        sequenceInfos.remove(seqInfo);
                    }
                    seqInfo.releaseResources();
                    seqInfo = null;
                    if (!logger.isFinest()) continue;
                    logger.finest(m_className, m_method, "Remove seqInfo" + seqId);
                }
            }
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private synchronized void releaseResources() {
        this.m_msgIds.clear();
        this.m_seqIds.clear();
        this.m_relatesToMsgId = null;
        this.m_wobNum = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void setInfo(WSRMCallbackData cbData) {
        String m_method = "setInfo";
        logger.entering(m_className, m_method);
        try {
            String msgId = cbData.getMessageId();
            String seqId = cbData.getSequenceId();
            int msgType = cbData.getMessageType();
            if (msgType < 1) return;
            if (msgType > totalMessageTypes) {
                return;
            }
            if (seqId == null) {
                seqId = msgId;
            }
            if (this.m_msgIds.contains(msgId) && this.m_seqIds.contains(seqId)) {
                if (cbData.getIncoming() && this.m_incomingMsgRecd[msgType - 1]) {
                    return;
                }
                if (!cbData.getIncoming() && this.m_outgoingMsgRecd[msgType - 1]) {
                    return;
                }
            }
            if (!this.m_msgIds.contains(msgId)) {
                this.m_msgIds.add(0, msgId);
            }
            if (!this.m_seqIds.contains(seqId)) {
                this.m_seqIds.add(0, seqId);
            }
            if (cbData.getIncoming()) {
                this.m_incomingMsgRecd[msgType - 1] = true;
            } else {
                this.m_outgoingMsgRecd[msgType - 1] = true;
            }
            if (sequencesByMsgId.get(msgId) == null) {
                sequencesByMsgId.put(msgId, this);
            }
            if (sequencesBySeqId.get(seqId) == null) {
                sequencesBySeqId.put(seqId, this);
            }
            switch (msgType) {
                case 1: {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "MSG_TYPE_CREATE_SEQUENCE_REQUEST");
                    }
                    StringTokenizer st = new StringTokenizer(seqId, "!");
                    String token = null;
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        if (token.startsWith("wobNum:") && token.length() > "wobNum:".length()) {
                            this.m_wobNum = token.substring("wobNum:".length());
                            if (sequencesByWobnum.containsKey(this.m_wobNum)) continue;
                            sequencesByWobnum.put(this.m_wobNum, this);
                            continue;
                        }
                        if (!token.startsWith("rm:") || token.length() <= "rm:".length()) continue;
                        String serviceType = token.substring("rm:".length());
                        if (serviceType.compareTo("oneWay") == 0) {
                            this.m_bWaitForResponse = false;
                            this.m_invokeType = 1;
                            continue;
                        }
                        if (serviceType.compareTo("request") == 0) {
                            this.m_bWaitForResponse = false;
                            this.m_invokeType = 3;
                            continue;
                        }
                        if (serviceType.compareTo("reply") == 0) {
                            this.m_bWaitForResponse = false;
                            this.m_invokeType = 4;
                            continue;
                        }
                        if (serviceType.compareTo("request.response") != 0) continue;
                        this.m_bWaitForResponse = true;
                        this.m_invokeType = 2;
                    }
                    if (waitForResponseWOBs.contains(this.m_wobNum)) {
                        waitForResponseWOBs.remove(this.m_wobNum);
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Done setInfo");
                    }
                    this.isObsolete();
                    return;
                }
                case 3: {
                    String rmAction;
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "MSG_TYPE_SERVICE_REQUEST");
                    }
                    if ((rmAction = cbData.getRMAction()) != null && rmAction.length() > 0) {
                        StringTokenizer st = new StringTokenizer(rmAction, "!");
                        String token = null;
                        while (st.hasMoreTokens()) {
                            String serviceType;
                            token = st.nextToken();
                            if (token.startsWith("wobNum:") && token.length() > "wobNum:".length()) {
                                this.m_wobNum = token.substring("wobNum:".length());
                                continue;
                            }
                            if (!token.startsWith("rm:") || token.length() <= "rm:".length() || (serviceType = token.substring("wobNum:".length())) == null) continue;
                            if (serviceType.compareTo("oneWay") == 0 || serviceType.compareTo("reply") == 0) {
                                this.m_bWaitForResponse = false;
                                continue;
                            }
                            if (serviceType.compareTo("request.response") != 0) continue;
                            this.m_bWaitForResponse = true;
                        }
                        if (waitForResponseWOBs.contains(this.m_wobNum)) {
                            waitForResponseWOBs.remove(this.m_wobNum);
                        }
                    }
                    this.m_serviceMsgReceived = true;
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Done setInfo");
                    }
                    this.isObsolete();
                    return;
                }
                case 4: {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "MSG_TYPE_SERVICE_RESPONSE");
                    }
                    this.m_bWaitForResponse = false;
                    this.m_relatesToMsgId = cbData.getRelatesToMsgId();
                    this.m_serviceMsgReceived = true;
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Done setInfo");
                    }
                    this.isObsolete();
                    return;
                }
                case 5: {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "MSG_TYPE_ACKNOWLEDGEMENT");
                    }
                    this.m_bAck = true;
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Done setInfo");
                    }
                    this.isObsolete();
                    return;
                }
                case 6: {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "MSG_TYPE_TERMINATE_SEQUENCE");
                    }
                    this.m_bSeqTerminated = true;
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Done setInfo");
                    }
                    this.isObsolete();
                    return;
                }
            }
            return;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private synchronized ArrayList getMsgIds() {
        return this.m_msgIds;
    }

    private synchronized ArrayList getSeqIds() {
        return this.m_seqIds;
    }

    public synchronized String getRelatesToMsgId() {
        return this.m_relatesToMsgId;
    }

    public synchronized void setWobNum(String wobNum) {
        this.m_wobNum = wobNum;
    }

    public synchronized String getwobNum() {
        return this.m_wobNum;
    }

    public synchronized void setAck(boolean bAck) {
        this.m_bAck = bAck;
    }

    public synchronized boolean getAck() {
        return this.m_bAck;
    }

    public synchronized void setWaitForResponse(boolean bWaitForResponse) {
        this.m_bWaitForResponse = bWaitForResponse;
    }

    public synchronized boolean getWaitForResponse() {
        return this.m_bWaitForResponse;
    }

    public synchronized void setSeqTerminated(boolean bSeqTerminated) {
        this.m_bSeqTerminated = bSeqTerminated;
    }

    public synchronized boolean getSeqTerminated() {
        return this.m_bSeqTerminated;
    }

    private synchronized int getRequestSeqStatus() {
        int status = 0;
        if (this.m_outgoingMsgRecd[0]) {
            status = 1;
            if (this.m_incomingMsgRecd[1]) {
                status = 2;
                if (this.m_outgoingMsgRecd[2]) {
                    status = 3;
                    if (this.m_incomingMsgRecd[4]) {
                        status = 4;
                        if (this.m_outgoingMsgRecd[5]) {
                            status = 5;
                            if (this.m_incomingMsgRecd[0]) {
                                status = 6;
                                if (this.m_outgoingMsgRecd[1]) {
                                    status = 7;
                                    if (this.m_incomingMsgRecd[3]) {
                                        status = 8;
                                        if (this.m_outgoingMsgRecd[4]) {
                                            status = 9;
                                            if (this.m_incomingMsgRecd[5]) {
                                                status = 10;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return status;
    }

    private synchronized int getInvokeSeqStatus() {
        int status = 0;
        if (this.m_outgoingMsgRecd[0]) {
            status = 1;
            if (this.m_incomingMsgRecd[1]) {
                status = 2;
                if (this.m_outgoingMsgRecd[2]) {
                    status = 3;
                    if (this.m_incomingMsgRecd[4]) {
                        status = 4;
                        if (this.m_outgoingMsgRecd[5]) {
                            WSRMSequenceInfo relatesToSeqInfo;
                            status = 5;
                            if (this.m_relatesToMsgId != null && (relatesToSeqInfo = WSRMSequenceInfo.getSequenceInfoByMsgId(this.m_relatesToMsgId)) != null) {
                                boolean[] incomingMsgRecd = relatesToSeqInfo.m_incomingMsgRecd;
                                boolean[] outgoingMsgRecd = relatesToSeqInfo.m_outgoingMsgRecd;
                                if (incomingMsgRecd[0]) {
                                    status = 6;
                                    if (outgoingMsgRecd[1]) {
                                        status = 7;
                                        if (incomingMsgRecd[3]) {
                                            status = 8;
                                            if (outgoingMsgRecd[4]) {
                                                status = 9;
                                                if (incomingMsgRecd[5]) {
                                                    status = 10;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return status;
    }

    private synchronized int getReceiveSeqStatus() {
        int status = 0;
        if (this.m_incomingMsgRecd[0]) {
            status = 21;
            if (this.m_outgoingMsgRecd[1]) {
                status = 22;
                if (this.m_incomingMsgRecd[3]) {
                    status = 43;
                    if (this.m_outgoingMsgRecd[4]) {
                        status = 44;
                        if (this.m_incomingMsgRecd[5]) {
                            status = 45;
                        }
                    }
                } else if (this.m_incomingMsgRecd[2]) {
                    status = 23;
                    if (this.m_outgoingMsgRecd[4]) {
                        status = 24;
                        if (this.m_incomingMsgRecd[5]) {
                            status = 25;
                            if (this.m_outgoingMsgRecd[0]) {
                                status = 26;
                                if (this.m_incomingMsgRecd[1]) {
                                    status = 27;
                                    if (this.m_outgoingMsgRecd[3]) {
                                        status = 28;
                                        if (this.m_incomingMsgRecd[4]) {
                                            status = 29;
                                            if (this.m_outgoingMsgRecd[5]) {
                                                status = 30;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return status;
    }

    public synchronized int getSeqStatus() {
        if (this.m_bInvoke) {
            return this.getInvokeSeqStatus();
        }
        return this.getReceiveSeqStatus();
    }

    public synchronized String getSeqStatusMsg() {
        int status = this.getSeqStatus();
        VWString msg = null;
        boolean bSync = false;
        if (this.m_bInvoke) {
            switch (this.m_invokeType) {
                case 1: {
                    msg = s_invoke_msg;
                    break;
                }
                case 2: {
                    msg = s_invoke_msg;
                    bSync = true;
                    break;
                }
                case 3: {
                    msg = s_invoke_msg;
                    bSync = false;
                    break;
                }
                case 4: {
                    msg = s_reply_msg;
                    bSync = false;
                }
            }
            switch (status) {
                case 1: {
                    return msg.toString(s_invoke_create_sequence);
                }
                case 2: {
                    return msg.toString(s_invoke_create_sequence_resp);
                }
                case 3: {
                    return msg.toString(s_invoke_service_request);
                }
                case 4: {
                    return msg.toString(s_invoke_service_request_ack);
                }
                case 5: {
                    if (bSync) {
                        return msg.toString(s_invoke_terminated_wiating_for_reply);
                    }
                    return msg.toString(s_invoke_terminated);
                }
                case 6: {
                    return msg.toString(s_invoke_resp_create_sequence);
                }
                case 7: {
                    return msg.toString(s_invoke_resp_create_sequence_resp);
                }
                case 8: {
                    return msg.toString(s_invoke_resp_service_response);
                }
                case 9: {
                    return msg.toString(s_invoke_resp_service_response_ack);
                }
                case 10: {
                    return msg.toString(s_invoke_resp_terminated);
                }
            }
        } else {
            msg = s_receive_msg;
            switch (status) {
                case 21: {
                    return s_receive_msg.toString(s_receive_create_sequence);
                }
                case 22: {
                    return s_receive_msg.toString(s_receive_create_sequence_resp);
                }
                case 23: {
                    return s_receive_msg.toString(s_receive_service_request);
                }
                case 24: {
                    return s_receive_msg.toString(s_receive_service_request_ack);
                }
                case 25: {
                    return s_receive_msg.toString(s_receive_terminated);
                }
                case 43: {
                    return s_response_msg.toString(s_response_service_response);
                }
                case 44: {
                    return s_response_msg.toString(s_response_service_response_ack);
                }
                case 45: {
                    return s_response_msg.toString(s_response_terminated);
                }
            }
        }
        return null;
    }

    public synchronized boolean setServicePerformed() {
        boolean prevValue = this.m_servicePerformed;
        this.m_servicePerformed = true;
        return prevValue;
    }

    public synchronized boolean isObsolete() {
        boolean bObsolete = false;
        if (this.m_obsoleteTime != 0L) {
            bObsolete = true;
        } else if (this.m_bSeqTerminated && this.m_serviceMsgReceived && (!this.m_bWaitForResponse || System.currentTimeMillis() - this.m_createTime > (long)WSRMCallbackData.SYNC_TIMEOUT)) {
            bObsolete = true;
            if (logger.isFinest()) {
                logger.finest(m_className, "isObsolete", "Sequence obsolete. SeqId = " + this.m_seqIds.get(0));
            }
            if (this.m_obsoleteTime == 0L) {
                this.m_obsoleteTime = System.currentTimeMillis();
            }
        }
        return bObsolete;
    }

    public synchronized void displaySeqInfo() {
        int i;
        String m_method = "displaySeqInfo";
        StringBuffer info = new StringBuffer(EOL);
        info = info.append("  Sequence Info").append(EOL);
        info = info.append("  ").append(this.getSeqStatusMsg()).append(EOL);
        for (i = 0; i < this.m_seqIds.size(); ++i) {
            info = info.append("    SeqId").append(i).append(") = ").append(this.m_seqIds.get(i)).append(EOL);
        }
        for (i = 0; i < this.m_msgIds.size(); ++i) {
            info = info.append("    MsgId(").append(i).append(") = ").append(this.m_msgIds.get(i)).append(EOL);
        }
        info = info.append("    relatesToMsgId = ").append(this.m_relatesToMsgId).append(EOL);
        info = info.append("    wobNum = ").append(this.m_wobNum).append(EOL);
        if (this.m_bInvoke) {
            info = info.append("    Invoke type = ").append(this.m_invokeType);
        }
        info = info.append("    WaitForResponse = ").append(this.m_bWaitForResponse).append(EOL);
        info = info.append("    serviceMsgReceived = ").append(this.m_serviceMsgReceived).append(EOL);
        info = info.append("    Ack = ").append(this.m_bAck).append(EOL);
        info = info.append("    SeqTerminated = ").append(this.m_bSeqTerminated).append(EOL);
        info = info.append("    CreateTime = ").append(this.m_createTime).append(EOL);
        info = info.append("    ObsoleteTime = ").append(this.m_obsoleteTime).append(EOL);
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, info.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void listAllSeqInfos() {
        String m_method = "listAllSeqInfos";
        logger.entering(m_className, m_method);
        try {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "# of sequenceInfos = " + sequenceInfos.size());
            }
            WSRMSequenceInfo seqInfo = null;
            for (int i = 0; i < sequenceInfos.size(); ++i) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "sequenceInfo # " + i);
                }
                seqInfo = (WSRMSequenceInfo)sequenceInfos.get(i);
                seqInfo.displaySeqInfo();
            }
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }
}

